/** @file   particleglass.cpp
 * @brief   Implementation of ParticleGlass - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "particleglass.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================

int ParticleGlass::s_averageLifetime = 15;


///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
ParticleGlass::ParticleGlass( const Vec2D& rP, const Vec2D& rD, int num ) :
  ParticleSystem()
{
  Vec2D normDir( rD );
  normDir.norm();
  float s = rD.length() / 3.0;
  Gradient g( Color(70,90,150), Color(110,140,220) );
  for ( int i=0; i < num; i++ ) {
    Particle* pP = new Particle();
    pP->m_pos = rP;
    pP->lifetime( s_averageLifetime + rand() % 10 );
    int r = rand() % 100;
    pP->setColor( g.getColorAt( r, 0,100 ) );
    
    pP->m_size = 2;
    pP->m_friction = 0.7;

    pP->m_dirVec = normDir;
    pP->m_dirVec *= s + ( static_cast<float>( rand() % 100 ) / 100.0 );
    pP->m_dirVec.rotate( (rand() % 128) - 64 );

    this->addParticle( pP );
  }
}



/** Destructor
 */
ParticleGlass::~ParticleGlass()
{
}

} // end of namespace
